 function pT = createPeriodOnsetOffSetTable(periodsExecuted, nTrials)
% Generate a old fashioned period onset/offset table from the new
% periodsExecuted table
%
% Do something like
% newP = load('NewProtocol.mat')
% pTable = createPeriodOnsetOffSetTable(newP.periodsExecuted, 60);
% pTable
%   1         142         143         172         173         469           0           0         470         570
% 571         648         649         678         679         975           0           0         976        1074
% 1075        1230        1231        1237           0           0           0           0        1238        1336
% 1337        1478        1479        1508        1509        1531        1532        1560        1561        1659
% 1660        1734        1735        1763        1764        1999        2000        2028        2029        2127
% ...
    try        
        pT = zeros(nTrials, 5*2);
        TrialCnt = 1;
        prevPeriod = 0;
        for i=1:length(periodsExecuted)
            period = periodsExecuted(i, 2);
            if period < prevPeriod
                TrialCnt = TrialCnt + 1;               
            end
            prevPeriod = period;
            pT(TrialCnt, period*2 - 1) = periodsExecuted(i, 3) + 1;
            pT(TrialCnt, period*2) = periodsExecuted(i, 4);
        end
    catch err
        error('Cought Error %s', err.message)
    end
